@extends('layouts.app')

@section('page-title', __('Customer Timeline'))

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('customer.index') }}">{{ __('Customer') }}</a></li>
    <li class="breadcrumb-item"> {{ $customer_data->first_name }} </li>
@endsection

@section('content')
    <div class="row  custom-timeline-2 ">
        <div class="col-xl-12">
            <div class="row gy-3">
                <div class="col-lg-3 col-6">
                    <div class="card stats-wrapper info-card">
                        <div class="card-body stats">
                            <div class="theme-avtar bg-success badge">
                                <i class="ti ti-user"></i>
                            </div>
                            <h6 class="mt-4 mb-2">{{ __('Customer Name') }}</h6>
                            <h3 class="mb-0">
                                {{ $customer_data->first_name . ' ' . $customer_data->last_name }} <span
                                    class="text-success text-sm">
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="card stats-wrapper info-card">
                        <div class="card-body stats">
                            <div class="theme-avtar bg-info badge">
                                <i class="ti ti-mail"></i>
                            </div>
                            <h6 class="mt-4 mb-2">{{ __('Customer Email') }}</h6>
                            <h3 class="mb-0">{{ $customer_data->email }}<span class="text-success text-sm">
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="card stats-wrapper info-card">
                        <div class="card-body stats">
                            <div class="theme-avtar bg-warning badge">
                                <i class="ti ti-report-money"></i>
                            </div>
                            <h6 class="mt-4 mb-2">{{ __('Total Spend') }}</h6>
                            <h3 class="mb-0">{{ $totalSpend['total_spend'] }}.00 <span class="text-success text-sm">
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="card stats-wrapper info-card">
                        <div class="card-body stats">
                            <div class="theme-avtar bg-dark badge">
                                <i class="ti ti-shopping-cart text-dark"></i>
                            </div>
                            <h6 class="mt-4 mb-2">{{ __('Total Orders') }}</h6>
                            <h3 class="mb-0">{{ $totalSpend['total_orders'] }} <span class="text-success text-sm">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @if (!empty($customer_data->regiester_date))
        <div @if (count($logs) > 0) class="my-custom-timeline" @endif>
            <div class="custom-timeline-inner">
                <div class="timeline">
                    @foreach ($logs as $key => $value)
                        @if ($key % 2 == 0)
                            @if ($value->log_type == 'register')
                                <div class="tl-container right">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 458 446" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M140.745 24.3826L327.039 24.3826V106.492V106.519L327.04 106.546C327.186 113.366 330.03 119.85 334.948 124.577C339.862 129.299 346.444 131.883 353.257 131.765H408.126C409.479 131.812 410.829 131.589 412.096 131.108C413.379 130.621 414.551 129.88 415.541 128.929C416.53 127.977 417.318 126.836 417.856 125.573C418.394 124.31 418.671 122.952 418.671 121.579C418.671 120.206 418.394 118.848 417.856 117.585C417.318 116.322 416.53 115.181 415.541 114.23C414.551 113.279 413.379 112.537 412.096 112.05C410.829 111.569 409.479 111.346 408.126 111.393H353.234H353.212L353.189 111.393C351.85 111.417 350.555 110.91 349.59 109.981C348.63 109.058 348.073 107.794 348.039 106.463V39.2428L432.976 124.246C432.977 124.246 432.978 124.247 432.979 124.248C433.95 125.227 434.496 126.549 434.5 127.928V400.715C434.493 406.256 432.288 411.569 428.37 415.487C424.452 419.405 419.14 421.61 413.598 421.617H140.745C135.203 421.61 129.89 419.406 125.971 415.488C122.053 411.57 119.848 406.258 119.84 400.716C119.84 400.716 119.84 400.716 119.84 400.715L119.84 325.281C119.84 322.496 118.734 319.826 116.764 317.856C114.795 315.887 112.125 314.781 109.34 314.781C106.555 314.781 103.884 315.887 101.915 317.856C99.9461 319.826 98.8398 322.496 98.8398 325.281L98.8398 400.718L98.8398 400.721C98.8525 411.83 103.271 422.479 111.126 430.333C118.981 438.188 129.631 442.605 140.74 442.617H140.742H413.602H413.604C424.712 442.605 435.362 438.187 443.216 430.333C451.071 422.479 455.488 411.829 455.5 400.721V400.718V127.922V127.914C455.479 120.978 452.725 114.329 447.836 109.409L447.831 109.405L344.964 6.45936C343.989 5.48375 342.832 4.70985 341.558 4.18188C340.284 3.6539 338.918 3.3822 337.539 3.38232L140.742 3.38232L140.74 3.38233C129.631 3.39394 118.981 7.81153 111.126 15.6659C103.271 23.5202 98.8525 34.1697 98.8398 45.2779V45.2808V165.328C98.8398 168.113 99.9461 170.783 101.915 172.752C103.884 174.722 106.555 175.828 109.34 175.828C112.125 175.828 114.795 174.722 116.764 172.752C118.734 170.783 119.84 168.113 119.84 165.328L119.84 45.2844C119.84 45.284 119.84 45.2835 119.84 45.2831C119.848 39.7417 122.053 34.4297 125.971 30.5117C129.89 26.5937 135.202 24.3896 140.744 24.3826C140.744 24.3826 140.745 24.3826 140.745 24.3826Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                                <path
                                                    d="M177.668 224.625H376.672C379.457 224.625 382.127 223.519 384.097 221.55C386.066 219.58 387.172 216.91 387.172 214.125C387.172 211.34 386.066 208.67 384.097 206.7C382.127 204.731 379.457 203.625 376.672 203.625H177.668C174.883 203.625 172.212 204.731 170.243 206.7C168.274 208.67 167.168 211.34 167.168 214.125C167.168 216.91 168.274 219.58 170.243 221.55C172.212 223.519 174.883 224.625 177.668 224.625Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                                <path
                                                    d="M177.668 151.445H261C263.785 151.445 266.455 150.339 268.425 148.37C270.394 146.401 271.5 143.73 271.5 140.945C271.5 138.161 270.394 135.49 268.425 133.521C266.455 131.552 263.785 130.445 261 130.445H177.668C174.883 130.445 172.212 131.552 170.243 133.521C168.274 135.49 167.168 138.161 167.168 140.945C167.168 143.73 168.274 146.401 170.243 148.37C172.212 150.339 174.883 151.445 177.668 151.445Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                                <path
                                                    d="M288.906 297.805C291.691 297.805 294.362 296.698 296.331 294.729C298.3 292.76 299.406 290.089 299.406 287.305C299.406 284.52 298.3 281.849 296.331 279.88C294.362 277.911 291.691 276.805 288.906 276.805H211.734C208.95 276.805 206.279 277.911 204.31 279.88C202.341 281.849 201.234 284.52 201.234 287.305C201.234 290.089 202.341 292.76 204.31 294.729C206.279 296.698 208.95 297.805 211.734 297.805H288.906Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                                <path
                                                    d="M217.094 370.984H376.672C379.457 370.984 382.127 369.878 384.097 367.909C386.066 365.94 387.172 363.269 387.172 360.484C387.172 357.7 386.066 355.029 384.097 353.06C382.127 351.091 379.457 349.984 376.672 349.984H217.094C214.309 349.984 211.638 351.091 209.669 353.06C207.7 355.029 206.594 357.7 206.594 360.484C206.594 363.269 207.7 365.94 209.669 367.909C211.638 369.878 214.309 370.984 217.094 370.984Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                                <path
                                                    d="M141.797 321.332L141.799 321.332L142.336 318.891C141.799 321.332 141.799 321.332 141.8 321.332L141.801 321.333L141.806 321.334L141.825 321.338L141.899 321.354L142.19 321.418L143.294 321.661C143.786 321.769 144.386 321.9 145.076 322.052C145.723 322.194 146.45 322.353 147.24 322.526C150.508 323.243 154.871 324.198 159.253 325.154C163.634 326.109 168.036 327.065 171.379 327.782C173.05 328.14 174.462 328.44 175.476 328.651C175.981 328.756 176.396 328.84 176.697 328.899C176.845 328.928 176.978 328.953 177.086 328.972C177.113 328.977 177.143 328.982 177.174 328.987C177.202 328.992 177.231 328.996 177.259 329C177.26 329 177.452 329.031 177.668 329.031H177.669C179.241 329.031 180.793 328.678 182.21 327.998C183.627 327.317 184.874 326.328 185.858 325.101C186.841 323.875 187.537 322.444 187.894 320.912C188.25 319.381 188.258 317.79 187.917 316.255L180.465 282.655C179.343 277.588 176.797 272.948 173.127 269.279C173.127 269.279 173.127 269.279 173.127 269.279L53.6234 149.771L53.6218 149.77C49.5144 145.67 43.9481 143.367 38.1447 143.367C32.3413 143.367 26.775 145.67 22.6676 149.77L22.6657 149.772L8.9125 163.529C8.91238 163.529 8.91226 163.529 8.91213 163.529C6.87946 165.562 5.26704 167.975 4.16692 170.631C3.06674 173.287 2.50049 176.133 2.50049 179.008C2.50049 181.883 3.06674 184.729 4.16692 187.385C5.2671 190.041 6.87966 192.454 8.9125 194.487L128.414 313.984C128.414 313.984 128.415 313.985 128.416 313.986C132.083 317.664 136.726 320.213 141.797 321.332ZM162.92 300.529L163.847 304.71L159.666 303.782L162.92 300.529ZM23.7616 179.64C23.5941 179.472 23.5 179.245 23.5 179.008C23.5 178.771 23.5938 178.544 23.761 178.376C23.7612 178.376 23.7614 178.376 23.7616 178.376L37.5123 164.621C37.6801 164.453 37.9075 164.359 38.1445 164.359C38.3816 164.359 38.609 164.453 38.7768 164.621L48.6364 174.481L33.6205 189.499L23.7616 179.64ZM63.3644 189.209L154.633 280.477L139.617 295.492L48.3486 204.226L63.3644 189.209Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ __('First Name:-') }}
                                                    </b></span><span>{{ $value->userinfo->first_name }} </span></li>
                                            <li><span><b>{{ __('Last Name:-') }}
                                                    </b></span><span>{{ $value->userinfo->last_name }} </span></li>
                                            <li><span><b>{{ 'Email:-' }}
                                                    </b></span><span>{{ $value->userinfo->email }}</span>
                                            </li>
                                            <li><span><b>{{ 'Contact:-' }}
                                                    </b></span><span>{{ $value->userinfo->mobile }}</span></li>
                                            <li><span><b>{{ 'Register Date:-' }} </b></span><span
                                                    class="end-date register-timeline">{{ $value->userinfo->regiester_date }}</span>
                                            </li>
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'last login')
                                <div class="tl-container right">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 460 460" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M198 406.277H36.9332C35.8025 406.277 34.7145 405.808 33.9252 405.019C33.1145 404.208 32.6665 403.141 32.6665 402.011C32.6665 401.989 32.6665 371.077 32.6665 371.077C32.6665 353.349 45.3172 337.733 64.8158 324.464C99.6318 300.699 155.973 285.723 219.333 285.723C229.787 285.723 240.048 286.149 250.075 286.939C258.864 287.643 266.587 281.072 267.291 272.261C267.973 263.451 261.403 255.749 252.592 255.045C241.755 254.171 230.661 253.723 219.333 253.723C148.464 253.723 85.7225 271.451 46.7678 298.011C17.0505 318.277 0.666504 344.027 0.666504 371.056V402.011C0.666504 411.611 4.48517 420.848 11.2905 427.653C18.0958 434.437 27.3118 438.277 36.9332 438.256C79.9412 438.277 198 438.277 198 438.277C206.832 438.277 214 431.088 214 422.277C214 413.445 206.832 406.277 198 406.277Z"
                                                    fill="black" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M219.333 0.666504C154.565 0.666504 102 53.2318 102 118C102 182.768 154.565 235.333 219.333 235.333C284.101 235.333 336.667 182.768 336.667 118C336.667 53.2318 284.101 0.666504 219.333 0.666504ZM219.333 32.6665C266.437 32.6665 304.667 70.8958 304.667 118C304.667 165.104 266.437 203.333 219.333 203.333C172.229 203.333 134 165.104 134 118C134 70.8958 172.229 32.6665 219.333 32.6665Z"
                                                    fill="black" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M361.242 405.104C387.098 408.986 414.426 400.965 434.33 381.061C467.653 347.738 467.653 293.637 434.33 260.336C401.029 227.013 346.928 227.013 313.605 260.336C293.701 280.24 285.68 307.568 289.562 333.445L240.026 382.96C237.018 385.968 235.333 390.042 235.333 394.288V443.333C235.333 452.165 242.501 459.333 251.333 459.333H300.378C304.624 459.333 308.698 457.648 311.706 454.64L361.242 405.104ZM360.133 372.25C354.629 370.778 348.741 372.357 344.709 376.389L293.765 427.333H267.333V400.901L318.277 349.957C322.309 345.925 323.888 340.037 322.416 334.533C317.68 316.72 322.266 296.922 336.24 282.949C357.061 262.128 390.874 262.128 411.717 282.949C432.538 303.792 432.538 337.605 411.717 358.426C397.744 372.4 377.946 376.986 360.133 372.25Z"
                                                    fill="black" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M357.616 337.051C348.592 328.027 348.592 313.371 357.616 304.347C366.64 295.323 381.296 295.323 390.32 304.347C399.344 313.371 399.344 328.027 390.32 337.051C381.296 346.075 366.64 346.075 357.616 337.051Z"
                                                    fill="black" />
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ 'Last Login Date:-' }} </b></span><span
                                                    class="end-date last-login-timeline">{{ json_decode($value->remark)->date }}</span>
                                            </li>
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'add wishlist')
                                <div class="tl-container right">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 360 513" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M344 0H16C11.7565 0 7.68688 1.68571 4.68629 4.68629C1.68571 7.68687 0 11.7565 0 16V484.9C-2.95595e-06 487.661 0.714524 490.375 2.07409 492.778C3.43365 495.182 5.39199 497.192 7.75864 498.614C10.1253 500.036 12.8197 500.822 15.5798 500.895C18.34 500.967 21.0719 500.324 23.51 499.028L174.118 418.971L336.167 509.954C338.602 511.321 341.352 512.027 344.145 512.002C346.937 511.977 349.674 511.221 352.084 509.81C354.494 508.399 356.493 506.382 357.881 503.959C359.27 501.536 360 498.793 360 496V16C360 11.7565 358.314 7.68687 355.314 4.68629C352.313 1.68571 348.243 0 344 0ZM328 468.667L182.161 386.785C179.823 385.472 177.193 384.768 174.512 384.737C171.831 384.706 169.185 385.35 166.818 386.608L32 458.272V32H328V468.667ZM170.811 302.467C173.503 304.356 176.712 305.369 180 305.369C183.288 305.369 186.497 304.356 189.189 302.467C218.834 281.667 241.859 259.556 257.624 236.741C272.189 215.662 279.877 194.686 279.854 176.08C279.829 154.365 268.072 136.092 249.172 128.394C228.191 119.847 203.086 125.857 180 144.408C156.915 125.856 131.808 119.846 110.829 128.394C91.929 136.094 80.172 154.364 80.146 176.08C80.123 194.686 87.811 215.662 102.376 236.741C118.141 259.556 141.166 281.669 170.811 302.467ZM122.9 158.029C125.382 157.062 128.028 156.584 130.691 156.622C140.316 156.622 153.681 161.991 168.567 177.195C170.057 178.717 171.836 179.926 173.799 180.751C175.762 181.577 177.87 182.002 180 182.002C182.13 182.002 184.238 181.577 186.201 180.751C188.164 179.926 189.943 178.717 191.433 177.195C210.923 157.288 227.803 154.24 237.1 158.029C243.924 160.809 247.844 167.402 247.854 176.118C247.879 197.142 229.854 232.194 180 269.605C130.15 232.194 112.121 197.142 112.146 176.119C112.156 167.4 116.076 160.809 122.9 158.029Z"
                                                    fill="black" />
                                            </svg>

                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ 'Product:-' }} </b></span><span
                                                    class="end-date wishlist-timeline">{{ json_decode($value->remark)->product }}</span>
                                            </li>
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'delete wishlist')
                                <div class="tl-container right">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 369 522" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M115.933 263.5H252.466C267.985 263.5 280.566 250.92 280.566 235.4C280.566 219.881 267.985 207.3 252.466 207.3H115.933C100.414 207.3 87.833 219.881 87.833 235.4C87.833 250.92 100.414 263.5 115.933 263.5ZM115.933 229.367H252.466C255.798 229.367 258.499 232.068 258.499 235.4C258.499 238.732 255.798 241.433 252.466 241.433H115.933C112.601 241.433 109.9 238.731 109.9 235.4C109.9 232.068 112.601 229.367 115.933 229.367Z" fill="black" stroke="black" stroke-width="5"/>
                                                <path d="M343.833 491.402V491.4V47.667C343.833 34.9097 333.49 24.567 320.733 24.567H47.666C34.9087 24.567 24.566 34.9097 24.566 47.667V491.4V491.402C24.5646 493.537 25.6904 495.513 27.5269 496.599C29.3643 497.686 31.6381 497.722 33.508 496.694L34.713 498.884L33.5082 496.693L170.659 421.262C170.661 421.26 170.662 421.259 170.664 421.258M343.833 491.402L196.53 423.449C188.857 419.204 179.541 419.204 171.869 423.449L170.664 421.258M343.833 491.402C343.835 493.536 342.709 495.513 340.872 496.599C339.035 497.686 336.761 497.722 334.891 496.694L333.686 498.884L334.891 496.693L197.74 421.261C197.738 421.26 197.737 421.259 197.735 421.258M343.833 491.402L197.735 421.258M170.664 421.258C179.086 416.601 189.312 416.601 197.735 421.258M170.664 421.258H197.735M44.1352 516.025L44.1358 516.025L181.292 440.591L181.292 440.59C183.103 439.594 185.297 439.594 187.108 440.59L187.108 440.591L324.264 516.026L324.265 516.026C332.97 520.811 343.555 520.644 352.105 515.587C360.654 510.53 365.899 501.335 365.9 491.401V47.667V47.664C365.87 22.7326 345.667 2.52964 320.736 2.5H320.733L47.666 2.5L47.663 2.5C22.7326 2.52964 2.52964 22.7327 2.5 47.664V47.667V491.4C2.5 501.334 7.74464 510.529 16.2954 515.586C24.845 520.643 35.4297 520.81 44.1352 516.025Z" fill="black" stroke="black" stroke-width="5"/>
                                            </svg>

                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ 'Product:-' }} </b></span><span
                                                    class="end-date dlt-wishlist-timeline">{{ App\Models\ActivityLog::products(json_decode($value->remark)->product) }}</span>
                                            </li>
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'add to cart')
                                <div class="tl-container right">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 512 480" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M407 0C349.109 0 302 47.109 302 105C302 162.891 349.109 210 407 210C464.891 210 512 162.891 512 105C512 47.109 464.891 0 407 0ZM452 120H422V150H392V120H362V90H392V60H422V90H452V120Z" fill="black"/>
                                                <path d="M137 360C145.3 360 429.767 360 418.602 360L451.854 231.753C441.432 235.455 430.458 237.753 419.047 238.782L418.732 240H348.295L349.412 226.609C339.046 221.676 329.578 215.37 320.866 208.077L318.205 240H255.795L250.794 180H294.853C288.681 170.799 284.074 160.604 280.292 150H139.031L119.027 60H0V90H94.974L148.294 330H137C112.186 330 92 350.186 92 375C92 399.814 112.186 420 137 420H154.763C153.082 424.715 152 429.716 152 435C152 459.814 172.186 480 197 480C221.814 480 242 459.814 242 435C242 429.716 240.918 424.715 239.237 420H304.763C303.082 424.715 302 429.716 302 435C302 459.814 322.186 480 347 480C371.814 480 392 459.814 392 435C392 429.716 390.918 424.715 389.237 420H422V390H137C128.724 390 122 383.276 122 375C122 366.724 128.724 360 137 360ZM345.795 270H410.953L395.398 330H340.794L345.795 270ZM315.705 270L310.704 330H263.294L258.293 270H315.705ZM233.205 330H179.037L165.701 270H228.204L233.205 330ZM145.698 180H220.705L225.706 240H159.035L145.698 180ZM212 435C212 443.276 205.276 450 197 450C188.724 450 182 443.276 182 435C182 426.724 188.724 420 197 420C205.276 420 212 426.724 212 435ZM362 435C362 443.276 355.276 450 347 450C338.724 450 332 443.276 332 435C332 426.724 338.724 420 347 420C355.276 420 362 426.724 362 435Z" fill="black"/>
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ 'Product:-' }} </b></span>
                                                <span
                                                    class="end-date">{{ App\Models\ActivityLog::products(json_decode($value->remark)->product) }}</span>
                                            </li>
                                            @if (json_decode($value->remark)->variant != '0')
                                                <li><span><b>{{ 'Variant:-' }} </b></span>
                                                    <span
                                                        class="end-date add-cart-timeline">{{ App\Models\ActivityLog::variants(json_decode($value->remark)->variant) }}</span>
                                                </li>
                                            @endif
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'remove to cart')
                                <div class="tl-container right">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 512 480" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M407 0C349.109 0 302 47.109 302 105C302 162.891 349.109 210 407 210C464.891 210 512 162.891 512 105C512 47.109 464.891 0 407 0ZM452 120H362V90H452V120Z" fill="black"/>
                                                <path d="M137 360C145.3 360 429.767 360 418.602 360L451.854 231.753C441.432 235.455 430.458 237.753 419.047 238.782L418.732 240H348.295L349.412 226.609C339.046 221.676 329.578 215.37 320.866 208.077L318.205 240H255.795L250.794 180H294.853C288.681 170.799 284.074 160.604 280.292 150H139.031L119.027 60H0V90H94.974L148.294 330H137C112.186 330 92 350.186 92 375C92 399.814 112.186 420 137 420H154.763C153.082 424.715 152 429.716 152 435C152 459.814 172.186 480 197 480C221.814 480 242 459.814 242 435C242 429.716 240.918 424.715 239.237 420H304.763C303.082 424.715 302 429.716 302 435C302 459.814 322.186 480 347 480C371.814 480 392 459.814 392 435C392 429.716 390.918 424.715 389.237 420H422V390H137C128.724 390 122 383.276 122 375C122 366.724 128.724 360 137 360ZM345.795 270H410.953L395.398 330H340.794L345.795 270ZM315.705 270L310.704 330H263.294L258.293 270H315.705ZM233.205 330H179.037L165.701 270H228.204L233.205 330ZM145.698 180H220.705L225.706 240H159.035L145.698 180ZM212 435C212 443.276 205.276 450 197 450C188.724 450 182 443.276 182 435C182 426.724 188.724 420 197 420C205.276 420 212 426.724 212 435ZM362 435C362 443.276 355.276 450 347 450C338.724 450 332 443.276 332 435C332 426.724 338.724 420 347 420C355.276 420 362 426.724 362 435Z" fill="black"/>
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ 'Product:-' }} </b></span>
                                                <span
                                                    class="end-date">{{ App\Models\ActivityLog::products(json_decode($value->remark)->product) }}</span>
                                            </li>
                                            @if (json_decode($value->remark)->variant != '0')
                                                <li><span><b>{{ 'Variant:-' }} </b></span>
                                                    <span
                                                        class="end-date dlt-cart-timeline">{{ App\Models\ActivityLog::variants(json_decode($value->remark)->variant) }}</span>
                                                </li>
                                            @endif
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'place order')
                                <div class="tl-container right">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 480 454" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M397.536 381.952C397.536 374.368 402.976 368.256 410.32 366.336C431.968 360.656 447.984 340.928 447.984 317.52V107.536C447.984 94.144 442.672 81.312 433.2 71.84L408.144 46.768C398.688 37.312 385.856 32 372.48 32H107.52C94.144 32 81.312 37.312 71.84 46.768L46.768 71.84C37.312 81.296 32 94.128 32 107.504V317.536C32 340.928 48.016 360.672 69.664 366.352C77.008 368.272 82.448 374.384 82.448 381.968C82.448 392.416 72.576 400.064 62.448 397.536C26.624 388.576 0 356.112 0 317.536V107.52C0 85.632 8.704 64.656 24.176 49.184L49.248 24.128C64.704 8.672 85.664 0 107.52 0H372.528C394.384 0 415.344 8.688 430.784 24.144L455.84 49.216C471.312 64.688 480 85.68 480 107.568V317.536C480 356.112 453.392 388.576 417.552 397.536C407.424 400.064 397.552 392.416 397.552 381.968L397.536 381.952Z" fill="black"/>
                                                <path d="M16 63.9839H464V95.9839H16V63.9839Z" fill="black"/>
                                                <path d="M229.968 359.904C219.616 359.904 209.872 355.872 202.544 348.544L184.72 330.72C178.48 324.48 178.48 314.336 184.72 308.096C190.96 301.856 201.104 301.856 207.344 308.096L225.168 325.92C228.656 329.408 231.344 329.392 234.768 325.92L297.84 262.848C304.08 256.608 314.224 256.608 320.464 262.848C326.704 269.104 326.704 279.232 320.464 285.472L257.392 348.528C250.064 355.856 240.336 359.904 229.968 359.904Z" fill="black"/>
                                                <path d="M243.712 453.024C164.32 453.024 99.7119 388.432 99.7119 309.024C99.7119 229.616 164.32 165.024 243.712 165.024C323.104 165.024 387.712 229.616 387.712 309.024C387.712 388.432 323.104 453.024 243.712 453.024ZM243.712 197.024C181.952 197.024 131.712 247.264 131.712 309.024C131.712 370.784 181.952 421.024 243.712 421.024C305.472 421.024 355.712 370.768 355.712 309.024C355.712 247.28 305.456 197.024 243.712 197.024Z" fill="black"/>
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ __('Order Id:-') }}
                                                    </b></span><span>{{ json_decode($value->remark)->order_id }} </span></li>
                                            <li><span><b>{{ __('Order Date:-') }}
                                                    </b></span><span>{{ Carbon\Carbon::parse(json_decode($value->remark)->order_date)->format('d M Y') }}
                                                </span></li>
                                            <li><span><b>{{ 'Product:-' }} </b></span>
                                                <span
                                                    class="end-date order-timeline">{{ App\Models\ActivityLog::products(json_decode($value->remark)->product) }}</span>
                                            </li>
                                            <li><span><b>{{ __('Order Price:-') }}
                                                    </b></span><span>{{ json_decode($value->remark)->price }} </span></li>
                                            <li><span><b>{{ __('Payment Type:-') }}
                                                    </b></span><span>{{ json_decode($value->remark)->payment_type }} </span>
                                            </li>
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @else
                            @if ($value->log_type == 'register')
                                <div class="tl-container left">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 458 446" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M140.745 24.3826L327.039 24.3826V106.492V106.519L327.04 106.546C327.186 113.366 330.03 119.85 334.948 124.577C339.862 129.299 346.444 131.883 353.257 131.765H408.126C409.479 131.812 410.829 131.589 412.096 131.108C413.379 130.621 414.551 129.88 415.541 128.929C416.53 127.977 417.318 126.836 417.856 125.573C418.394 124.31 418.671 122.952 418.671 121.579C418.671 120.206 418.394 118.848 417.856 117.585C417.318 116.322 416.53 115.181 415.541 114.23C414.551 113.279 413.379 112.537 412.096 112.05C410.829 111.569 409.479 111.346 408.126 111.393H353.234H353.212L353.189 111.393C351.85 111.417 350.555 110.91 349.59 109.981C348.63 109.058 348.073 107.794 348.039 106.463V39.2428L432.976 124.246C432.977 124.246 432.978 124.247 432.979 124.248C433.95 125.227 434.496 126.549 434.5 127.928V400.715C434.493 406.256 432.288 411.569 428.37 415.487C424.452 419.405 419.14 421.61 413.598 421.617H140.745C135.203 421.61 129.89 419.406 125.971 415.488C122.053 411.57 119.848 406.258 119.84 400.716C119.84 400.716 119.84 400.716 119.84 400.715L119.84 325.281C119.84 322.496 118.734 319.826 116.764 317.856C114.795 315.887 112.125 314.781 109.34 314.781C106.555 314.781 103.884 315.887 101.915 317.856C99.9461 319.826 98.8398 322.496 98.8398 325.281L98.8398 400.718L98.8398 400.721C98.8525 411.83 103.271 422.479 111.126 430.333C118.981 438.188 129.631 442.605 140.74 442.617H140.742H413.602H413.604C424.712 442.605 435.362 438.187 443.216 430.333C451.071 422.479 455.488 411.829 455.5 400.721V400.718V127.922V127.914C455.479 120.978 452.725 114.329 447.836 109.409L447.831 109.405L344.964 6.45936C343.989 5.48375 342.832 4.70985 341.558 4.18188C340.284 3.6539 338.918 3.3822 337.539 3.38232L140.742 3.38232L140.74 3.38233C129.631 3.39394 118.981 7.81153 111.126 15.6659C103.271 23.5202 98.8525 34.1697 98.8398 45.2779V45.2808V165.328C98.8398 168.113 99.9461 170.783 101.915 172.752C103.884 174.722 106.555 175.828 109.34 175.828C112.125 175.828 114.795 174.722 116.764 172.752C118.734 170.783 119.84 168.113 119.84 165.328L119.84 45.2844C119.84 45.284 119.84 45.2835 119.84 45.2831C119.848 39.7417 122.053 34.4297 125.971 30.5117C129.89 26.5937 135.202 24.3896 140.744 24.3826C140.744 24.3826 140.745 24.3826 140.745 24.3826Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                                <path
                                                    d="M177.668 224.625H376.672C379.457 224.625 382.127 223.519 384.097 221.55C386.066 219.58 387.172 216.91 387.172 214.125C387.172 211.34 386.066 208.67 384.097 206.7C382.127 204.731 379.457 203.625 376.672 203.625H177.668C174.883 203.625 172.212 204.731 170.243 206.7C168.274 208.67 167.168 211.34 167.168 214.125C167.168 216.91 168.274 219.58 170.243 221.55C172.212 223.519 174.883 224.625 177.668 224.625Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                                <path
                                                    d="M177.668 151.445H261C263.785 151.445 266.455 150.339 268.425 148.37C270.394 146.401 271.5 143.73 271.5 140.945C271.5 138.161 270.394 135.49 268.425 133.521C266.455 131.552 263.785 130.445 261 130.445H177.668C174.883 130.445 172.212 131.552 170.243 133.521C168.274 135.49 167.168 138.161 167.168 140.945C167.168 143.73 168.274 146.401 170.243 148.37C172.212 150.339 174.883 151.445 177.668 151.445Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                                <path
                                                    d="M288.906 297.805C291.691 297.805 294.362 296.698 296.331 294.729C298.3 292.76 299.406 290.089 299.406 287.305C299.406 284.52 298.3 281.849 296.331 279.88C294.362 277.911 291.691 276.805 288.906 276.805H211.734C208.95 276.805 206.279 277.911 204.31 279.88C202.341 281.849 201.234 284.52 201.234 287.305C201.234 290.089 202.341 292.76 204.31 294.729C206.279 296.698 208.95 297.805 211.734 297.805H288.906Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                                <path
                                                    d="M217.094 370.984H376.672C379.457 370.984 382.127 369.878 384.097 367.909C386.066 365.94 387.172 363.269 387.172 360.484C387.172 357.7 386.066 355.029 384.097 353.06C382.127 351.091 379.457 349.984 376.672 349.984H217.094C214.309 349.984 211.638 351.091 209.669 353.06C207.7 355.029 206.594 357.7 206.594 360.484C206.594 363.269 207.7 365.94 209.669 367.909C211.638 369.878 214.309 370.984 217.094 370.984Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                                <path
                                                    d="M141.797 321.332L141.799 321.332L142.336 318.891C141.799 321.332 141.799 321.332 141.8 321.332L141.801 321.333L141.806 321.334L141.825 321.338L141.899 321.354L142.19 321.418L143.294 321.661C143.786 321.769 144.386 321.9 145.076 322.052C145.723 322.194 146.45 322.353 147.24 322.526C150.508 323.243 154.871 324.198 159.253 325.154C163.634 326.109 168.036 327.065 171.379 327.782C173.05 328.14 174.462 328.44 175.476 328.651C175.981 328.756 176.396 328.84 176.697 328.899C176.845 328.928 176.978 328.953 177.086 328.972C177.113 328.977 177.143 328.982 177.174 328.987C177.202 328.992 177.231 328.996 177.259 329C177.26 329 177.452 329.031 177.668 329.031H177.669C179.241 329.031 180.793 328.678 182.21 327.998C183.627 327.317 184.874 326.328 185.858 325.101C186.841 323.875 187.537 322.444 187.894 320.912C188.25 319.381 188.258 317.79 187.917 316.255L180.465 282.655C179.343 277.588 176.797 272.948 173.127 269.279C173.127 269.279 173.127 269.279 173.127 269.279L53.6234 149.771L53.6218 149.77C49.5144 145.67 43.9481 143.367 38.1447 143.367C32.3413 143.367 26.775 145.67 22.6676 149.77L22.6657 149.772L8.9125 163.529C8.91238 163.529 8.91226 163.529 8.91213 163.529C6.87946 165.562 5.26704 167.975 4.16692 170.631C3.06674 173.287 2.50049 176.133 2.50049 179.008C2.50049 181.883 3.06674 184.729 4.16692 187.385C5.2671 190.041 6.87966 192.454 8.9125 194.487L128.414 313.984C128.414 313.984 128.415 313.985 128.416 313.986C132.083 317.664 136.726 320.213 141.797 321.332ZM162.92 300.529L163.847 304.71L159.666 303.782L162.92 300.529ZM23.7616 179.64C23.5941 179.472 23.5 179.245 23.5 179.008C23.5 178.771 23.5938 178.544 23.761 178.376C23.7612 178.376 23.7614 178.376 23.7616 178.376L37.5123 164.621C37.6801 164.453 37.9075 164.359 38.1445 164.359C38.3816 164.359 38.609 164.453 38.7768 164.621L48.6364 174.481L33.6205 189.499L23.7616 179.64ZM63.3644 189.209L154.633 280.477L139.617 295.492L48.3486 204.226L63.3644 189.209Z"
                                                    fill="black" stroke="black" stroke-width="5" />
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ __('First Name:-') }}
                                                    </b></span><span>{{ $value->userinfo->first_name }} </span></li>
                                            <li><span><b>{{ __('Last Name:-') }}
                                                    </b></span><span>{{ $value->userinfo->last_name }} </span></li>
                                            <li><span><b>{{ 'Email:-' }}
                                                    </b></span><span>{{ $value->userinfo->email }}</span>
                                            </li>
                                            <li><span><b>{{ 'Contact:-' }}
                                                    </b></span><span>{{ $value->userinfo->mobile }}</span></li>
                                            <li><span><b>{{ 'Register Date:-' }} </b></span><span
                                                    class="end-date register-timeline">{{ $value->userinfo->regiester_date }}</span>
                                            </li>
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'last login')
                                <div class="tl-container left">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 460 460" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M198 406.277H36.9332C35.8025 406.277 34.7145 405.808 33.9252 405.019C33.1145 404.208 32.6665 403.141 32.6665 402.011C32.6665 401.989 32.6665 371.077 32.6665 371.077C32.6665 353.349 45.3172 337.733 64.8158 324.464C99.6318 300.699 155.973 285.723 219.333 285.723C229.787 285.723 240.048 286.149 250.075 286.939C258.864 287.643 266.587 281.072 267.291 272.261C267.973 263.451 261.403 255.749 252.592 255.045C241.755 254.171 230.661 253.723 219.333 253.723C148.464 253.723 85.7225 271.451 46.7678 298.011C17.0505 318.277 0.666504 344.027 0.666504 371.056V402.011C0.666504 411.611 4.48517 420.848 11.2905 427.653C18.0958 434.437 27.3118 438.277 36.9332 438.256C79.9412 438.277 198 438.277 198 438.277C206.832 438.277 214 431.088 214 422.277C214 413.445 206.832 406.277 198 406.277Z"
                                                    fill="black" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M219.333 0.666504C154.565 0.666504 102 53.2318 102 118C102 182.768 154.565 235.333 219.333 235.333C284.101 235.333 336.667 182.768 336.667 118C336.667 53.2318 284.101 0.666504 219.333 0.666504ZM219.333 32.6665C266.437 32.6665 304.667 70.8958 304.667 118C304.667 165.104 266.437 203.333 219.333 203.333C172.229 203.333 134 165.104 134 118C134 70.8958 172.229 32.6665 219.333 32.6665Z"
                                                    fill="black" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M361.242 405.104C387.098 408.986 414.426 400.965 434.33 381.061C467.653 347.738 467.653 293.637 434.33 260.336C401.029 227.013 346.928 227.013 313.605 260.336C293.701 280.24 285.68 307.568 289.562 333.445L240.026 382.96C237.018 385.968 235.333 390.042 235.333 394.288V443.333C235.333 452.165 242.501 459.333 251.333 459.333H300.378C304.624 459.333 308.698 457.648 311.706 454.64L361.242 405.104ZM360.133 372.25C354.629 370.778 348.741 372.357 344.709 376.389L293.765 427.333H267.333V400.901L318.277 349.957C322.309 345.925 323.888 340.037 322.416 334.533C317.68 316.72 322.266 296.922 336.24 282.949C357.061 262.128 390.874 262.128 411.717 282.949C432.538 303.792 432.538 337.605 411.717 358.426C397.744 372.4 377.946 376.986 360.133 372.25Z"
                                                    fill="black" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M357.616 337.051C348.592 328.027 348.592 313.371 357.616 304.347C366.64 295.323 381.296 295.323 390.32 304.347C399.344 313.371 399.344 328.027 390.32 337.051C381.296 346.075 366.64 346.075 357.616 337.051Z"
                                                    fill="black" />
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ 'Last Login Date:-' }} </b></span><span
                                                    class="end-date last-login-timeline">{{ json_decode($value->remark)->date }}</span>
                                            </li>
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'add wishlist')
                                <div class="tl-container left">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 360 513" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M344 0H16C11.7565 0 7.68688 1.68571 4.68629 4.68629C1.68571 7.68687 0 11.7565 0 16V484.9C-2.95595e-06 487.661 0.714524 490.375 2.07409 492.778C3.43365 495.182 5.39199 497.192 7.75864 498.614C10.1253 500.036 12.8197 500.822 15.5798 500.895C18.34 500.967 21.0719 500.324 23.51 499.028L174.118 418.971L336.167 509.954C338.602 511.321 341.352 512.027 344.145 512.002C346.937 511.977 349.674 511.221 352.084 509.81C354.494 508.399 356.493 506.382 357.881 503.959C359.27 501.536 360 498.793 360 496V16C360 11.7565 358.314 7.68687 355.314 4.68629C352.313 1.68571 348.243 0 344 0ZM328 468.667L182.161 386.785C179.823 385.472 177.193 384.768 174.512 384.737C171.831 384.706 169.185 385.35 166.818 386.608L32 458.272V32H328V468.667ZM170.811 302.467C173.503 304.356 176.712 305.369 180 305.369C183.288 305.369 186.497 304.356 189.189 302.467C218.834 281.667 241.859 259.556 257.624 236.741C272.189 215.662 279.877 194.686 279.854 176.08C279.829 154.365 268.072 136.092 249.172 128.394C228.191 119.847 203.086 125.857 180 144.408C156.915 125.856 131.808 119.846 110.829 128.394C91.929 136.094 80.172 154.364 80.146 176.08C80.123 194.686 87.811 215.662 102.376 236.741C118.141 259.556 141.166 281.669 170.811 302.467ZM122.9 158.029C125.382 157.062 128.028 156.584 130.691 156.622C140.316 156.622 153.681 161.991 168.567 177.195C170.057 178.717 171.836 179.926 173.799 180.751C175.762 181.577 177.87 182.002 180 182.002C182.13 182.002 184.238 181.577 186.201 180.751C188.164 179.926 189.943 178.717 191.433 177.195C210.923 157.288 227.803 154.24 237.1 158.029C243.924 160.809 247.844 167.402 247.854 176.118C247.879 197.142 229.854 232.194 180 269.605C130.15 232.194 112.121 197.142 112.146 176.119C112.156 167.4 116.076 160.809 122.9 158.029Z"
                                                    fill="black" />
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ 'Product:-' }} </b></span><span
                                                    class="end-date wishlist-timeline">{{ App\Models\ActivityLog::products(json_decode($value->remark)->product) }}</span>
                                            </li>
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'delete wishlist')
                                <div class="tl-container left">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 369 522" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M115.933 263.5H252.466C267.985 263.5 280.566 250.92 280.566 235.4C280.566 219.881 267.985 207.3 252.466 207.3H115.933C100.414 207.3 87.833 219.881 87.833 235.4C87.833 250.92 100.414 263.5 115.933 263.5ZM115.933 229.367H252.466C255.798 229.367 258.499 232.068 258.499 235.4C258.499 238.732 255.798 241.433 252.466 241.433H115.933C112.601 241.433 109.9 238.731 109.9 235.4C109.9 232.068 112.601 229.367 115.933 229.367Z" fill="black" stroke="black" stroke-width="5"/>
                                                <path d="M343.833 491.402V491.4V47.667C343.833 34.9097 333.49 24.567 320.733 24.567H47.666C34.9087 24.567 24.566 34.9097 24.566 47.667V491.4V491.402C24.5646 493.537 25.6904 495.513 27.5269 496.599C29.3643 497.686 31.6381 497.722 33.508 496.694L34.713 498.884L33.5082 496.693L170.659 421.262C170.661 421.26 170.662 421.259 170.664 421.258M343.833 491.402L196.53 423.449C188.857 419.204 179.541 419.204 171.869 423.449L170.664 421.258M343.833 491.402C343.835 493.536 342.709 495.513 340.872 496.599C339.035 497.686 336.761 497.722 334.891 496.694L333.686 498.884L334.891 496.693L197.74 421.261C197.738 421.26 197.737 421.259 197.735 421.258M343.833 491.402L197.735 421.258M170.664 421.258C179.086 416.601 189.312 416.601 197.735 421.258M170.664 421.258H197.735M44.1352 516.025L44.1358 516.025L181.292 440.591L181.292 440.59C183.103 439.594 185.297 439.594 187.108 440.59L187.108 440.591L324.264 516.026L324.265 516.026C332.97 520.811 343.555 520.644 352.105 515.587C360.654 510.53 365.899 501.335 365.9 491.401V47.667V47.664C365.87 22.7326 345.667 2.52964 320.736 2.5H320.733L47.666 2.5L47.663 2.5C22.7326 2.52964 2.52964 22.7327 2.5 47.664V47.667V491.4C2.5 501.334 7.74464 510.529 16.2954 515.586C24.845 520.643 35.4297 520.81 44.1352 516.025Z" fill="black" stroke="black" stroke-width="5"/>
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ 'Product:-' }} </b></span><span
                                                    class="end-date dlt-wishlist-timeline">{{ App\Models\ActivityLog::products(json_decode($value->remark)->product) }}</span>
                                            </li>
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'add to cart')
                                <div class="tl-container left">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 512 480" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M407 0C349.109 0 302 47.109 302 105C302 162.891 349.109 210 407 210C464.891 210 512 162.891 512 105C512 47.109 464.891 0 407 0ZM452 120H422V150H392V120H362V90H392V60H422V90H452V120Z" fill="black"/>
                                                <path d="M137 360C145.3 360 429.767 360 418.602 360L451.854 231.753C441.432 235.455 430.458 237.753 419.047 238.782L418.732 240H348.295L349.412 226.609C339.046 221.676 329.578 215.37 320.866 208.077L318.205 240H255.795L250.794 180H294.853C288.681 170.799 284.074 160.604 280.292 150H139.031L119.027 60H0V90H94.974L148.294 330H137C112.186 330 92 350.186 92 375C92 399.814 112.186 420 137 420H154.763C153.082 424.715 152 429.716 152 435C152 459.814 172.186 480 197 480C221.814 480 242 459.814 242 435C242 429.716 240.918 424.715 239.237 420H304.763C303.082 424.715 302 429.716 302 435C302 459.814 322.186 480 347 480C371.814 480 392 459.814 392 435C392 429.716 390.918 424.715 389.237 420H422V390H137C128.724 390 122 383.276 122 375C122 366.724 128.724 360 137 360ZM345.795 270H410.953L395.398 330H340.794L345.795 270ZM315.705 270L310.704 330H263.294L258.293 270H315.705ZM233.205 330H179.037L165.701 270H228.204L233.205 330ZM145.698 180H220.705L225.706 240H159.035L145.698 180ZM212 435C212 443.276 205.276 450 197 450C188.724 450 182 443.276 182 435C182 426.724 188.724 420 197 420C205.276 420 212 426.724 212 435ZM362 435C362 443.276 355.276 450 347 450C338.724 450 332 443.276 332 435C332 426.724 338.724 420 347 420C355.276 420 362 426.724 362 435Z" fill="black"/>
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ 'Product:-' }} </b></span>
                                                <span
                                                    class="end-date">{{ App\Models\ActivityLog::products(json_decode($value->remark)->product) }}</span>
                                            </li>
                                            @if (json_decode($value->remark)->variant != '0')
                                                <li><span><b>{{ 'Variant:-' }} </b></span>
                                                    <span
                                                        class="end-date add-cart-timeline">{{ App\Models\ActivityLog::variants(json_decode($value->remark)->variant) }}</span>
                                                </li>
                                            @endif
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'remove to cart')
                                <div class="tl-container left">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 512 480" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M407 0C349.109 0 302 47.109 302 105C302 162.891 349.109 210 407 210C464.891 210 512 162.891 512 105C512 47.109 464.891 0 407 0ZM452 120H362V90H452V120Z" fill="black"/>
                                                <path d="M137 360C145.3 360 429.767 360 418.602 360L451.854 231.753C441.432 235.455 430.458 237.753 419.047 238.782L418.732 240H348.295L349.412 226.609C339.046 221.676 329.578 215.37 320.866 208.077L318.205 240H255.795L250.794 180H294.853C288.681 170.799 284.074 160.604 280.292 150H139.031L119.027 60H0V90H94.974L148.294 330H137C112.186 330 92 350.186 92 375C92 399.814 112.186 420 137 420H154.763C153.082 424.715 152 429.716 152 435C152 459.814 172.186 480 197 480C221.814 480 242 459.814 242 435C242 429.716 240.918 424.715 239.237 420H304.763C303.082 424.715 302 429.716 302 435C302 459.814 322.186 480 347 480C371.814 480 392 459.814 392 435C392 429.716 390.918 424.715 389.237 420H422V390H137C128.724 390 122 383.276 122 375C122 366.724 128.724 360 137 360ZM345.795 270H410.953L395.398 330H340.794L345.795 270ZM315.705 270L310.704 330H263.294L258.293 270H315.705ZM233.205 330H179.037L165.701 270H228.204L233.205 330ZM145.698 180H220.705L225.706 240H159.035L145.698 180ZM212 435C212 443.276 205.276 450 197 450C188.724 450 182 443.276 182 435C182 426.724 188.724 420 197 420C205.276 420 212 426.724 212 435ZM362 435C362 443.276 355.276 450 347 450C338.724 450 332 443.276 332 435C332 426.724 338.724 420 347 420C355.276 420 362 426.724 362 435Z" fill="black"/>
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ 'Product:-' }} </b></span>
                                                <span
                                                    class="end-date">{{ App\Models\ActivityLog::products(json_decode($value->remark)->product) }}</span>
                                            </li>
                                            @if (json_decode($value->remark)->variant != '0')
                                                <li><span><b>{{ 'Variant:-' }} </b></span>
                                                    <span
                                                        class="end-date dlt-cart-timeline">{{ App\Models\ActivityLog::variants(json_decode($value->remark)->variant) }}</span>
                                                </li>
                                            @endif
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @elseif ($value->log_type == 'place order')
                                <div class="tl-container left">
                                    <span class="support-time"></span>
                                    <div class="tl-box">
                                        <span class="tl-btn licence-btn">
                                            <svg width="13" height="14" viewBox="0 0 480 454" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M397.536 381.952C397.536 374.368 402.976 368.256 410.32 366.336C431.968 360.656 447.984 340.928 447.984 317.52V107.536C447.984 94.144 442.672 81.312 433.2 71.84L408.144 46.768C398.688 37.312 385.856 32 372.48 32H107.52C94.144 32 81.312 37.312 71.84 46.768L46.768 71.84C37.312 81.296 32 94.128 32 107.504V317.536C32 340.928 48.016 360.672 69.664 366.352C77.008 368.272 82.448 374.384 82.448 381.968C82.448 392.416 72.576 400.064 62.448 397.536C26.624 388.576 0 356.112 0 317.536V107.52C0 85.632 8.704 64.656 24.176 49.184L49.248 24.128C64.704 8.672 85.664 0 107.52 0H372.528C394.384 0 415.344 8.688 430.784 24.144L455.84 49.216C471.312 64.688 480 85.68 480 107.568V317.536C480 356.112 453.392 388.576 417.552 397.536C407.424 400.064 397.552 392.416 397.552 381.968L397.536 381.952Z" fill="black"/>
                                                <path d="M16 63.9839H464V95.9839H16V63.9839Z" fill="black"/>
                                                <path d="M229.968 359.904C219.616 359.904 209.872 355.872 202.544 348.544L184.72 330.72C178.48 324.48 178.48 314.336 184.72 308.096C190.96 301.856 201.104 301.856 207.344 308.096L225.168 325.92C228.656 329.408 231.344 329.392 234.768 325.92L297.84 262.848C304.08 256.608 314.224 256.608 320.464 262.848C326.704 269.104 326.704 279.232 320.464 285.472L257.392 348.528C250.064 355.856 240.336 359.904 229.968 359.904Z" fill="black"/>
                                                <path d="M243.712 453.024C164.32 453.024 99.7119 388.432 99.7119 309.024C99.7119 229.616 164.32 165.024 243.712 165.024C323.104 165.024 387.712 229.616 387.712 309.024C387.712 388.432 323.104 453.024 243.712 453.024ZM243.712 197.024C181.952 197.024 131.712 247.264 131.712 309.024C131.712 370.784 181.952 421.024 243.712 421.024C305.472 421.024 355.712 370.768 355.712 309.024C355.712 247.28 305.456 197.024 243.712 197.024Z" fill="black"/>
                                            </svg>
                                            {{ $value->log_type }}
                                        </span>
                                        <ul>
                                            <li><span><b>{{ __('Order Id:-') }}
                                                    </b></span><span>{{ json_decode($value->remark)->order_id }} </span></li>
                                            <li><span><b>{{ __('Order Date:-') }}
                                                    </b></span><span>{{ Carbon\Carbon::parse(json_decode($value->remark)->order_date)->format('d M Y') }}
                                                </span></li>
                                            <li><span><b>{{ 'Product:-' }} </b></span>
                                                <span
                                                    class="end-date order-timeline">{{ App\Models\ActivityLog::products(json_decode($value->remark)->product) }}</span>
                                            </li>
                                            <li><span><b>{{ __('Order Price:-') }}
                                                    </b></span><span>{{ json_decode($value->remark)->price }} </span></li>
                                            <li><span><b>{{ __('Payment Type:-') }}
                                                    </b></span><span>{{ json_decode($value->remark)->payment_type }} </span>
                                            </li>
                                        </ul>
                                        <div class="time-wrapper d-flex align-content-center">
                                            <span class="time">{{ $value->created_at->format('d M Y h:i A') }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
        @else
        <div class="text-center pt-5">
            <h2>{{ __('User') }} {{ $customer_data->first_name }} {{ __('has not registered.') }}</h2>
        </div>
        @endif
    </div>
@endsection
