@php
    $modules = \App\Models\Webhook::modules();
    $methods = \App\Models\Webhook::methods();
@endphp

{{ Form::open(['route' => ['webhook.update', $webhook[0]['id']], 'method' => 'PUT']) }}
<div class="row">
    <div class="col-12">
        <div class="form-group">
            {{ Form::label('Module', __('Module'), ['class' => 'col-form-label']) }}
            <select name="module" class="form-control select2 multi-select" id="module">
                @foreach ($modules as $key => $value)
                    <option value="{{ $key }}" {{ $key == $webhook[0]['module'] ? 'selected' : '' }}>
                        {{ __($value) }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="col-12">
        <div class="form-group">
            {{ Form::label('Method', __('Method'), ['class' => 'col-form-label']) }}
            <select name="method" class="form-control select2 multi-select" id="method">
                @foreach ($methods as $key => $value)
                    <option value="{{ $key }}" {{ $key == $webhook[0]['method'] ? 'selected' : '' }}>
                        {{ __($value) }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="col-12">
        <div class="form-group">
            {{ Form::label('Url', __('Url'), ['class' => 'col-form-label']) }}
            {{ Form::text('webbbook_url', $webhook[0]['url'], ['class' => 'form-control ', 'placeholder' => 'WebBook Url']) }}
        </div>
    </div>
</div>
<div class="modal-footer pb-0">
    <input type="button" value="{{ __('Cancel') }}" class="btn btn-secondary btn-badge" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Update') }}" class="btn btn-primary btn-badge mx-1">
</div>
{{ Form::close() }}


<script src="{{ asset('assets/js/plugins/choices.min.js') }}"></script>
<script>
    if ($(".multi-select").length > 0) {
        $($(".multi-select")).each(function(index, element) {
            var id = $(element).attr('id');
            var multipleCancelButton = new Choices(
                '#' + id, {
                    removeItemButton: true,
                }
            );
        });
    }
    var textRemove = new Choices(
        document.getElementById('choices-text-remove-button'), {
            delimiter: ',',
            editItems: true,
            maxItemCount: 5,
            removeItemButton: true,
        }
    );
</script>
