<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) ?? 'en' }}" dir="{{ ($currantLang == 'ar' || $currantLang == 'he') ? 'rtl' : 'ltr' }}">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1" />
  <meta name="author" content="{{ config('app.name') ?? Greentic}}">
  <meta name="base-url" content="{{ URL::to('/') }}">
  <meta name="csrf-token" content="{{ csrf_token() }}">
   {!! metaKeywordSetting($metakeyword ?? null,$metadesc ?? null,$metaimage ?? null,$slug) !!}
  <title>@yield('page-title')</title>
  <link
    href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
    rel="stylesheet">
  <link rel="stylesheet" href="{{ asset('themes/' . $currentTheme . '/assets/css/all.min.css') }}">
  <link rel="stylesheet" href="{{ asset('themes/' . $currentTheme . '/assets/css/swiper-bundle.min.css') }}" />
 
    <link rel="stylesheet" href="{{ asset('themes/' . $currentTheme . '/assets/css/main-style.css') }}">

  <script src="{{ asset('themes/' . $currentTheme . '/assets/js/tailwind.js') }}"></script>
 
    <meta name="mobile-wep-app-capable" content="yes">
    <meta name="apple-mobile-wep-app-capable" content="yes">
    <meta name="msapplication-starturl" content="/">
    <!-- Favicon icon -->
    <link rel="icon" href="{{ get_file($themeSettings['header_favicon'] ?? '') }}" type="favicon" />
    <link rel="apple-touch-icon" href="{{ get_file($themeSettings['header_favicon'] ?? '') }}">
    @if ($store->enable_pwa_store == 'on')
        <link rel="manifest"
            href="{{ asset('storage/uploads/customer_app/store_' . $store->id . '/manifest.json') }}" />
    @endif
    @if (!empty($store->pwa_store($store->slug)->theme_color))
        <meta name="theme-color" content="{{ $store->pwa_store($store->slug)->theme_color }}" />
    @endif
    @if (!empty($store->pwa_store($store->slug)->background_color))
        <meta name="apple-mobile-web-app-status-bar"
            content="{{ $store->pwa_store($store->slug)->background_color }}" />
    @endif
    <style>
        {!! $storecss ?? '' !!}
    </style>
    @stack('page-style')

    <!-- Load jQuery first -->
    <script src="{{ asset('js/jquery.min.js') }}"></script>
    <!-- Then load Select2 -->
    @if($currantLang == 'ar' || $currantLang == 'he')
        <link rel="stylesheet" href="{{ asset('assets/css/rtl-floating-wpp.min.css') }}">
    @else
        <link rel="stylesheet" href="{{ asset('assets/css/floating-wpp.min.css') }}">
    @endif
    <link rel="stylesheet" href="{{ asset('assets/css/plugins/select2.min.css') }}">
    <script src="{{ asset('assets/js/plugins/select2.min.js') }}"></script>
</head>

<body>
    <div class="overlay" id="filter-overlay"></div>
   @include('front_end.partison.announcement')
   @include('front_end.partison.header')
    @if(isset($pixelScript))
        @foreach ($pixelScript as $script)
            <?= $script ?>
        @endforeach
    @endif

    @yield('content')
    @include('front_end.partison.footer')

    @include('front_end.jQueryRoute')
  <!-- Swiper JS -->
  <script src="{{ asset('themes/' . $currentTheme . '/assets/js/swiper-bundle.min.js') }}"></script>
 
  <script src="{{ asset('themes/' . $currentTheme . '/assets/js/custom.js') }}"></script>

   <!--Theme Routes Script-->
    
    <!--scripts end here-->
   @if ($message = Session::get('success'))
        <script>
            var site_url = $('meta[name="base-url"]').attr('content');
            notifier.show('Success', '{!! $message !!}', 'success', site_url +
                '/public/assets/images/notification/ok-48.png', 4000);
        </script>
    @endif

    @if ($message = Session::get('error'))
        <script>
            var site_url = $('meta[name="base-url"]').attr('content');
            notifier.show('Error', '{!! $message !!}', 'danger', site_url +
                '/public/assets/images/notification/high_priority-48.png', 4000);
        </script>
    @endif
    @include('front_end.hooks.footer_link')
    @stack('page-script')
    <script>

        function show_toastr(title, message, type) {
            var o, i;
            var icon = '';
            var cls = '';
            if (type == 'success') {
                cls = 'primary';
                notifier.show('Success', message, 'success', site_url + '/public/assets/images/notification/ok-48.png', 4000);
            } else {
                cls = 'danger';
                notifier.show('Error', message, 'danger', site_url + '/public/assets/images/notification/high_priority-48.png', 4000);
            }
        }
    </script>
</body>
</html>
